#include "CRfePurHidKeyboardReaderDialog.h"

#include <QMessageBox>

#include <reader/app/QrfeRfePurHidKeyboardReader>

#include <QrfeResourceGlobal>
#include <QrfeProgressDialog>

CRfePurHidKeyboardReaderDialog::CRfePurHidKeyboardReaderDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	setInfoEdit(ui.infoEdit);

	connect(ui.okButton, 				SIGNAL(clicked()), 			this, SLOT(accept()));
	connect(ui.reloadSettingsButton,	SIGNAL(clicked()), 			this, SLOT(getSettings()));
	connect(ui.setSettingsButton,		SIGNAL(clicked()), 			this, SLOT(setSettings()));

	connect(ui.rebootButton, 				SIGNAL(clicked()), 			this, SLOT(rebootDevice()));
	connect(ui.storeButton, 				SIGNAL(clicked()), 			this, SLOT(storeSettings()));
	connect(ui.restoreButton, 				SIGNAL(clicked()), 			this, SLOT(restoreFactory()));
}

CRfePurHidKeyboardReaderDialog::~CRfePurHidKeyboardReaderDialog()
{

}


int CRfePurHidKeyboardReaderDialog::exec ( QrfeReaderInterface* ph )
{
	m_reader = qobject_cast<QrfeRfePurHidKeyboardReader*>(ph);
	if( m_reader == 0 )
		return 0;

	clearInfo();

	ui.settingsWidget->setEnabled(false);
	ui.setSettingsButton->setEnabled(false);

	connect( m_reader, 			SIGNAL(lostConnection()),
			this, 				  SLOT(reject()) );

	//ulong sw_ver = m_reader->softwareRevision();

	QrfeProgressDialog pb("Reading Settings From Reader...", QrfeGlobal::FLOATING, parentWidget());
	pb.setVisible(true);

	getSettings();

	pb.hide();

	return QDialog::exec();
}

void CRfePurHidKeyboardReaderDialog::done( int r )
{
	disconnect( m_reader, 			SIGNAL(lostConnection()),
				this, 				  SLOT(reject()) );

	QDialog::done(r);
}



void CRfePurHidKeyboardReaderDialog::getSettings()
{
	clearInfo();

	QrfeRfePurHidKeyboardReader::SETTINGS settings;

	if(m_reader->getSettings(settings) == QrfeGlobal::RES_OK){
		infoSetOK("-- Retrieved Settings from reader --");

		ui.attenuationSpinBox->setValue(settings.attenuation);
		ui.timeoutSpinBox->setValue(settings.powerSafeTime);
		ui.prependEnterCheckBox->setChecked(settings.prependEnter);
		ui.appendEnterCheckBox->setChecked(settings.appendEnter);
		ui.resetTimeSpinBox->setValue(settings.deleteTime);

		ui.settingsWidget->setEnabled(true);
		ui.setSettingsButton->setEnabled(true);
	}
	else{
		infoSetError("-- Could not get Settings --");

		ui.settingsWidget->setEnabled(false);
		ui.setSettingsButton->setEnabled(false);
	}
}

void CRfePurHidKeyboardReaderDialog::setSettings()
{
	clearInfo();

	QrfeRfePurHidKeyboardReader::SETTINGS settings;
	settings.prependEnter 	= ui.prependEnterCheckBox->isChecked();
	settings.appendEnter	= ui.appendEnterCheckBox->isChecked();
	settings.attenuation	= ui.attenuationSpinBox->value();
	settings.powerSafeTime	= ui.timeoutSpinBox->value();
	settings.deleteTime		= ui.resetTimeSpinBox->value();

	if(m_reader->setSettings(settings) == QrfeGlobal::RES_OK){
		infoSetOK("-- Wrote Settings to reader --");
	}
	else{
		infoSetError("-- Could not write Settings --");
	}
}


void CRfePurHidKeyboardReaderDialog::storeSettings()
{
	clearInfo();
	if(m_reader->saveSettingsPermanent() == QrfeGlobal::RES_OK)
	{
		infoSetOK("-- Settings stored  --");
	}
	else
	{
		infoSetError("-- Could not store settings --");
	}

}

void CRfePurHidKeyboardReaderDialog::restoreFactory()
{
	clearInfo();
	if(m_reader->restoreFactorySettings() == QrfeGlobal::RES_OK){
		infoSetOK("-- Factory settings restored  --");

		QrfeProgressDialog pb("Reading Settings From Reader...", QrfeGlobal::FLOATING, parentWidget());
		pb.setVisible(true);

		getSettings();

		pb.hide();
	}
	else{
		infoSetError("-- Could not restore factory settings --");
	}

}



void CRfePurHidKeyboardReaderDialog::rebootDevice()
{
	clearInfo();

	QString 				readerId	= m_reader->readerId();
	//QrfeGlobal::DeviceType	deviceType 	= m_reader->deviceType();
	QString 				deviceName 	= m_reader->deviceName();

	if(m_reader->reboot() == QrfeGlobal::RES_OK){
		m_reader->destroy();
		infoSet("-- The device will reboot --");

		QList<QVariant> params;
		params.append(QString("Rebooting device..."));
		params.append((uint)2500);
		params.append(QVariant::fromValue(qobject_cast<QWidget*>(parent())));
		emit appendGlobalJob(JOB_WaitForSpeciifedTimeWithDialog, params);

		QDialog::accept();
	}
	else{
		infoSet("-- Could not reboot device --");
		showNOK();
		return;
	}
}
